%% Declare and define transition matrix
T=[0.6 0.4 0; 0.3 0.1 0.2; 0.1 0.5 0.8]


%% Initialize
p=[0,1,0]'; %initial probability vector - definitely in state 1

bar(p)
set(gca, 'FontSize', 20);
ylim([0 1])

%% Run the update many times by rerunning this section
p=T*p;
bar(p)
set(gca, 'FontSize', 20);
ylim([0 1])

%% Probability flow into state 1
T(1,2)*p(2)+T(1,3)*p(3)

%% Probability flow out of state 1
T(2,1)*p(1)+T(3,1)*p(1)

%% Initialize in a new initial state
p=[0,0,1]'; %initial probability vector - definitely in state 1

figure(2)
bar(p)
set(gca, 'FontSize', 20);
ylim([0 1])

%% Run the update many times by rerunning this section
p=T*p;
bar(p)
set(gca, 'FontSize', 20);
ylim([0 1])
